package com.xforceplus.unicharm.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unicharm.entity.SellerInvoice;
import com.xforceplus.unicharm.service.ISellerInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-21
 */
@RestController
public class SellerInvoiceController {

  @Autowired
  private ISellerInvoiceService sellerInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoice ${table.comment}
   * @return
   */
  @GetMapping("/sellerinvoices" )
  public XfR getSellerInvoices(XfPage page, SellerInvoice sellerInvoice) {
    return XfR.ok(sellerInvoiceServiceImpl.page(page, Wrappers.query(sellerInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sellerInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/sellerinvoices")
  public XfR save(@RequestBody SellerInvoice sellerInvoice) {
     return XfR.ok(sellerInvoiceServiceImpl.save(sellerInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sellerInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/sellerinvoices/{id}")
  public XfR putUpdate(@RequestBody SellerInvoice sellerInvoice,@PathVariable Long id) {
      sellerInvoice.setId(id);
      return XfR.ok(sellerInvoiceServiceImpl.updateById(sellerInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sellerInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sellerinvoices/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoice sellerInvoice,@PathVariable Long id) {
      SellerInvoice upsellerInvoice = sellerInvoiceServiceImpl.getById(id);
      if(upsellerInvoice != null){
        upsellerInvoice = ObjectCopyUtils.copyProperties(sellerInvoice,upsellerInvoice,true);
      }
      return XfR.ok(sellerInvoiceServiceImpl.updateById(upsellerInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceServiceImpl.querys(params));
  }

}
