package com.xforceplus.versionfuncapp.controller;


/**
 * 123feign客户端
 *
 * @author ultraman
 * @date 2023-01-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.versionfuncapp.entity.Bill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "version-func-app")
public interface BillFeignApi {

  /**
   * 通过id查询123
   * @param  id
   * @return R
   */
  @GetMapping("/bill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增123
   * @param bill 123
   * @return R
   */
  @PostMapping("/bill/add")
  public R save(@RequestBody Bill bill);

  /**
   * 修改123
   * @param bill 123
   * @return R
   */
  @PostMapping("/bill/update")
  public R updateById(@RequestBody Bill bill);

  /**
   * 通过id删除123
   * @param  id
   * @return R
   */
  @DeleteMapping("/bill/del/{id}" )
  public R removeById(@PathVariable Long id);

}