package com.xforceplus.versionfuncapp.controller;


/**
 * 12345678feign客户端
 *
 * @author ultraman
 * @date 2023-01-03
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.versionfuncapp.entity.Project;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "version-func-app")
public interface ProjectFeignApi {

  /**
   * 通过id查询12345678
   * @param  id
   * @return R
   */
  @GetMapping("/project/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增12345678
   * @param project 12345678
   * @return R
   */
  @PostMapping("/project/add")
  public R save(@RequestBody Project project);

  /**
   * 修改12345678
   * @param project 12345678
   * @return R
   */
  @PostMapping("/project/update")
  public R updateById(@RequestBody Project project);

  /**
   * 通过id删除12345678
   * @param  id
   * @return R
   */
  @DeleteMapping("/project/del/{id}" )
  public R removeById(@PathVariable Long id);

}