package com.xforceplus.versionfuncapp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-08
 */
public enum BillType {

    A("a", "普通单据"),
    B("b", "增值单据"),
    C("c", "已提交"),
    D("d", "增值税电子专用发票"),
    E("e", "验真成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillType fromCode(String code){
        switch(code) {
            case "a":
                return A;
            case "b":
                return B;
            case "c":
                return C;
            case "d":
                return D;
            case "e":
                return E;
            default:
                return null;
        }
    }
}
