package com.xforceplus.walmartreport.controller;


/**
 * 1对1 和 1对1feign客户端
 *
 * @author ultraman
 * @date 2022-08-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.CargoDiffRelated;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "walmart-report")
public interface CargoDiffRelatedFeignApi {

  /**
   * 通过id查询1对1 和 1对1
   * @param  id
   * @return R
   */
  @GetMapping("/cargoDiffRelated/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增1对1 和 1对1
   * @param cargoDiffRelated 1对1 和 1对1
   * @return R
   */
  @PostMapping("/cargoDiffRelated/add")
  public R save(@RequestBody CargoDiffRelated cargoDiffRelated);

  /**
   * 修改1对1 和 1对1
   * @param cargoDiffRelated 1对1 和 1对1
   * @return R
   */
  @PostMapping("/cargoDiffRelated/update")
  public R updateById(@RequestBody CargoDiffRelated cargoDiffRelated);

  /**
   * 通过id删除1对1 和 1对1
   * @param  id
   * @return R
   */
  @DeleteMapping("/cargoDiffRelated/del/{id}" )
  public R removeById(@PathVariable Long id);

}