package com.xforceplus.walmartreport.controller;


/**
 * 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22feign客户端
 *
 * @author ultraman
 * @date 2022-08-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.SellerInvoiceCargoDiff;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "walmart-report")
public interface SellerInvoiceCargoDiffFeignApi {

  /**
   * 通过id查询销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param  id
   * @return R
   */
  @GetMapping("/sellerInvoiceCargoDiff/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param sellerInvoiceCargoDiff 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @return R
   */
  @PostMapping("/sellerInvoiceCargoDiff/add")
  public R save(@RequestBody SellerInvoiceCargoDiff sellerInvoiceCargoDiff);

  /**
   * 修改销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param sellerInvoiceCargoDiff 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @return R
   */
  @PostMapping("/sellerInvoiceCargoDiff/update")
  public R updateById(@RequestBody SellerInvoiceCargoDiff sellerInvoiceCargoDiff);

  /**
   * 通过id删除销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param  id
   * @return R
   */
  @DeleteMapping("/sellerInvoiceCargoDiff/del/{id}" )
  public R removeById(@PathVariable Long id);

}