package com.xforceplus.walmartreport.controller;


/**
 * 以JV为主键feign客户端
 *
 * @author ultraman
 * @date 2022-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.walmartreport.entity.OrgAdmin;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "walmart-report")
public interface OrgAdminFeignApi {

  /**
   * 通过id查询以JV为主键
   * @param  id
   * @return R
   */
  @GetMapping("/orgAdmin/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增以JV为主键
   * @param orgAdmin 以JV为主键
   * @return R
   */
  @PostMapping("/orgAdmin/add")
  public R save(@RequestBody OrgAdmin orgAdmin);

  /**
   * 修改以JV为主键
   * @param orgAdmin 以JV为主键
   * @return R
   */
  @PostMapping("/orgAdmin/update")
  public R updateById(@RequestBody OrgAdmin orgAdmin);

  /**
   * 通过id删除以JV为主键
   * @param  id
   * @return R
   */
  @DeleteMapping("/orgAdmin/del/{id}" )
  public R removeById(@PathVariable Long id);

}