package com.xforceplus.walmartreport.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-11-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.walmartreport.entity.RecordLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "walmart-report")
public interface RecordLogFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/recordLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param recordLog ${table.comment}
   * @return R
   */
  @PostMapping("/recordLog/add")
  public R save(@RequestBody RecordLog recordLog);

  /**
   * 修改${table.comment}
   * @param recordLog ${table.comment}
   * @return R
   */
  @PostMapping("/recordLog/update")
  public R updateById(@RequestBody RecordLog recordLog);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/recordLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}