package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 黑名单状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum BlackListStatus {

    _1("1", "启用"),
    _9("9", "不启用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BlackListStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BlackListStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
