package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum FlowType {

    _1("1", "商品"),
    _2("2", "费用"),
    _3("3", "外部红票"),
    _4("4", "内部红票"),
    _5("5", "供应商红票"),
    _6("6", "租赁"),
    _7("7", "直接认证"),
    _8("8", "Ariba");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FlowType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FlowType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
