package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum InvType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    JU("ju", "增值税普通发票（卷票）"),
    CT("ct", "增值税电子普通发票（通行费）"),
    V("v", "机动车统一销售发票"),
    CB("cb", "增值税电子普通发票（区块链）"),
    SE("se", "增值税电子专用发票"),
    CD("cd", "浙江通用（电子）发票"),
    VS("vs", "二手车销售统一发票"),
    QC("qc", "全电增值税电子普通发票"),
    QS("qs", "全电增值税电子专用发票"),
    CZ("cz", "全电增值税纸质普通发票"),
    SZ("sz", "全电增值税纸质专用发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "ct":
                return CT;
            case "v":
                return V;
            case "cb":
                return CB;
            case "se":
                return SE;
            case "cd":
                return CD;
            case "vs":
                return VS;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            default:
                return null;
        }
    }
}
