package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据来源
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum InvoiceOrigin {

    _0("0", "税件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceOrigin fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
