package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 公告发布状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum NoticeStatus {

    _1("1", "未发布"),
    _2("2", "已发布");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NoticeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoticeStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
