package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 进项发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum PurInvoiceOrigin {

    TAX_WARE_LOW("taxWareLow", "低频同步"),
    WAPP("wapp", "WAPP");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PurInvoiceOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PurInvoiceOrigin fromCode(String code){
        switch(code) {
            case "taxWareLow":
                return TAX_WARE_LOW;
            case "wapp":
                return WAPP;
            default:
                return null;
        }
    }
}
