package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字信息表审核状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum RedAuditStatus {

    TZD0000("TZD0000", "审核通过"),
    TZD0074("TZD0074", "已核销"),
    TZD0072("TZD0072", "待查证"),
    TZD0082("TZD0082", "已撤销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedAuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedAuditStatus fromCode(String code){
        switch(code) {
            case "TZD0000":
                return TZD0000;
            case "TZD0074":
                return TZD0074;
            case "TZD0072":
                return TZD0072;
            case "TZD0082":
                return TZD0082;
            default:
                return null;
        }
    }
}
