package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字信息表状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum RedInvStatus2 {

    _0("0", "待开具"),
    _1("1", "已开具"),
    _2("2", "已撤销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedInvStatus2(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedInvStatus2 fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
