package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 撤销状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum RevokeStatus {

    _0("0", "未撤销"),
    _1("1", "撤销中"),
    _2("2", "撤销成功"),
    _3("3", "撤销失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RevokeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RevokeStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
