package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方开具状态
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum SellerInvStatus {

    _0("0", "0-默认"),
    _1("1", "1-无销方信息（非协同）"),
    _2("2", "2-销方信息未到（协同）"),
    _3("3", "3-销方信息已到（协同）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerInvStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerInvStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
