package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销项发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum SellerInvoiceOrigin {

    _1("1", "辅助抽取"),
    _5("5", "直连开具"),
    _7("7", "手工回填"),
    _99("99", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerInvoiceOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerInvoiceOrigin fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "5":
                return _5;
            case "7":
                return _7;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
