package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 销方类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum SellerType {

    SELLER("SELLER", "供应商"),
    CHC("CHC", "CHC"),
    JV("JV", "JV"),
    SHC("SHC", "SHC"),
    DC("DC", "DC");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SellerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerType fromCode(String code){
        switch(code) {
            case "SELLER":
                return SELLER;
            case "CHC":
                return CHC;
            case "JV":
                return JV;
            case "SHC":
                return SHC;
            case "DC":
                return DC;
            default:
                return null;
        }
    }
}
