package com.xforceplus.walmartreport.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 终端类型
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
public enum TerminalType {

    _1("1", "单盘"),
    _2("2", "服务器"),
    _4("4", "区块链");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TerminalType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TerminalType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
