package com.xforceplus.walmartreport.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvSellerRedNotification implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 红字信息表唯一标识
   */
  private String pid;

  /**
   * 备注
   */
  private String remark;

  /**
   * 业务单据类型
   */
  @TableField("salesbillType")
  private String salesbillType;

  /**
   * 红字信息表编号
   */
  @TableField("applyTaxNo")
  private String applyTaxNo;

  /**
   * 申请原因
   */
  private String reason;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 原发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 销方集团id
   */
  @TableField("sellerGroupId")
  private String sellerGroupId;

  /**
   * 销方租户id
   */
  @TableField("sellerTenantId")
  private String sellerTenantId;

  /**
   * 销方组织ID
   */
  @TableField("sellerId")
  private String sellerId;

  /**
   * 销方编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方集团id
   */
  @TableField("purchaserGroupId")
  private String purchaserGroupId;

  /**
   * 购方租户id
   */
  @TableField("purchaserTenantId")
  private String purchaserTenantId;

  /**
   * 购方组织ID
   */
  @TableField("purchaserId")
  private String purchaserId;

  /**
   * 购方编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 业务单号
   */
  @TableField("billNo")
  private String billNo;

  /**
   * 撤销流水号
   */
  @TableField("revokeSerialNo")
  private String revokeSerialNo;

  /**
   * 撤销失败原因
   */
  @TableField("revokeMessage")
  private String revokeMessage;

  /**
   * ext1
   */
  private String ext1;

  /**
   * ext1
   */
  private String ext2;

  /**
   * ext1
   */
  private String ext3;

  /**
   * ext1
   */
  private String ext4;

  /**
   * ext1
   */
  private String ext5;

  /**
   * ext1
   */
  private String ext6;

  /**
   * ext1
   */
  private String ext7;

  /**
   * ext1
   */
  private String ext8;

  /**
   * ext1
   */
  private String ext9;

  /**
   * ext1
   */
  private String ext10;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 红字信息表状态
   */
  @TableField("redTableStatus")
  private String redTableStatus;

  /**
   * batchId
   */
  @TableField("batchId")
  private String batchId;

  /**
   * 用户角色
   */
  @TableField("userRole")
  private String userRole;

  /**
   * 申请类型
   */
  @TableField("applyType")
  private String applyType;

  /**
   * 申请状态
   */
  @TableField("applyStatus")
  private String applyStatus;

  /**
   * 红冲申请原因
   */
  @TableField("petroleumReason")
  private String petroleumReason;

  /**
   * 发票类型
   */
  @TableField("invType")
  private String invType;

  /**
   * 特殊发票标记
   */
  @TableField("specialInvoiceFlag")
  private String specialInvoiceFlag;

  /**
   * 是否删除
   */
  @TableField("isDelete")
  private String isDelete;

  /**
   * 数据来源
   */
  @TableField("invoiceOrigin")
  private String invoiceOrigin;

  /**
   * 业务类型
   */
  @TableField("businessBillType")
  private String businessBillType;

  /**
   * 红蓝标识
   */
  @TableField("invoiceColor")
  private String invoiceColor;

  /**
   * 红字信息表审核状态
   */
  @TableField("redAuditStatus")
  private String redAuditStatus;

  /**
   * 撤销状态
   */
  @TableField("revokeStatus")
  private String revokeStatus;

  /**
   * 销货清单文件打印标志
   */
  @TableField("saleListFileFlag")
  private String saleListFileFlag;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 扣除额
   */
  private BigDecimal deduction;

  /**
   * 申请单号
   */
  @TableField("requestBillNo")
  private String requestBillNo;

  /**
   * JV code
   */
  @TableField("jvCode")
  private String jvCode;

  /**
   * 红字信息表业务类型
   */
  @TableField("redInvBusiType")
  private String redInvBusiType;

  /**
   * 红字信息表创建方式
   */
  @TableField("redNotificationSource")
  private String redNotificationSource;

  /**
   * 开票日期
   */
  @TableField("paperDrawDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrawDate;

  /**
   * 申请日期
   */
  @TableField("applyDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyDate;

  /**
   * markFlag
   */
  @TableField("markFlag")
  private Long markFlag;

  /**
   * 处理状态
   */
  @TableField("handleStatus")
  private Long handleStatus;

  /**
   * 所属期
   */
  @TableField("applyPeriod")
  private String applyPeriod;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("pid", pid);
      map.put("remark", remark);
      map.put("salesbillType", salesbillType);
      map.put("applyTaxNo", applyTaxNo);
      map.put("reason", reason);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("originInvoiceType", originInvoiceType);
      map.put("sellerGroupId", sellerGroupId);
      map.put("sellerTenantId", sellerTenantId);
      map.put("sellerId", sellerId);
      map.put("sellerNo", sellerNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("purchaserGroupId", purchaserGroupId);
      map.put("purchaserTenantId", purchaserTenantId);
      map.put("purchaserId", purchaserId);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("taxRate", taxRate);
      map.put("billNo", billNo);
      map.put("revokeSerialNo", revokeSerialNo);
      map.put("revokeMessage", revokeMessage);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("redTableStatus", redTableStatus);
      map.put("batchId", batchId);
      map.put("userRole", userRole);
      map.put("applyType", applyType);
      map.put("applyStatus", applyStatus);
      map.put("petroleumReason", petroleumReason);
      map.put("invType", invType);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      map.put("isDelete", isDelete);
      map.put("invoiceOrigin", invoiceOrigin);
      map.put("businessBillType", businessBillType);
      map.put("invoiceColor", invoiceColor);
      map.put("redAuditStatus", redAuditStatus);
      map.put("revokeStatus", revokeStatus);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("taxAmount", taxAmount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("deduction", deduction);
      map.put("requestBillNo", requestBillNo);
      map.put("jvCode", jvCode);
      map.put("redInvBusiType", redInvBusiType);
      map.put("redNotificationSource", redNotificationSource);
      map.put("paperDrawDate", BocpGenUtils.toTimestamp(paperDrawDate));
      map.put("applyDate", BocpGenUtils.toTimestamp(applyDate));
      map.put("markFlag", markFlag);
      map.put("handleStatus", handleStatus);
      map.put("applyPeriod", applyPeriod);
      return map;
  }

  public static InvSellerRedNotification fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvSellerRedNotification entity = new InvSellerRedNotification();
    if(map.containsKey("pid")) {
      Object obj = map.get("pid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillType")) {
      Object obj = map.get("salesbillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTaxNo")) {
      Object obj = map.get("applyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerGroupId")) {
      Object obj = map.get("sellerGroupId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerGroupId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantId")) {
      Object obj = map.get("sellerTenantId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerId")) {
      Object obj = map.get("sellerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserGroupId")) {
      Object obj = map.get("purchaserGroupId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserGroupId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantId")) {
      Object obj = map.get("purchaserTenantId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserId")) {
      Object obj = map.get("purchaserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("revokeSerialNo")) {
      Object obj = map.get("revokeSerialNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRevokeSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("revokeMessage")) {
      Object obj = map.get("revokeMessage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRevokeMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTableStatus")) {
      Object obj = map.get("redTableStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedTableStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchId")) {
      Object obj = map.get("batchId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userRole")) {
      Object obj = map.get("userRole");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyType")) {
      Object obj = map.get("applyType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyStatus")) {
      Object obj = map.get("applyStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("petroleumReason")) {
      Object obj = map.get("petroleumReason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPetroleumReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invType")) {
      Object obj = map.get("invType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDelete")) {
      Object obj = map.get("isDelete");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDelete((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrigin")) {
      Object obj = map.get("invoiceOrigin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAuditStatus")) {
      Object obj = map.get("redAuditStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("revokeStatus")) {
      Object obj = map.get("revokeStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRevokeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleListFileFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("requestBillNo")) {
      Object obj = map.get("requestBillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jvCode")) {
      Object obj = map.get("jvCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvBusiType")) {
      Object obj = map.get("redInvBusiType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedInvBusiType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationSource")) {
      Object obj = map.get("redNotificationSource");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrawDate")) {
      Object obj = map.get("paperDrawDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrawDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrawDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrawDate(null);
      }
    }
    if(map.containsKey("applyDate")) {
      Object obj = map.get("applyDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyDate(null);
      }
    }
    if(map.containsKey("markFlag")) {
      Object obj = map.get("markFlag");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMarkFlag((Long)obj);
        } else if(obj instanceof String) {
          entity.setMarkFlag(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMarkFlag(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHandleStatus((Long)obj);
        } else if(obj instanceof String) {
          entity.setHandleStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setHandleStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("applyPeriod")) {
      Object obj = map.get("applyPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyPeriod((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
