package com.xforceplus.walmartreport.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
 * </p>
 *
 * @author ultraman
 * @since 2022-09-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SellerInvoiceCargoDiff implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 月份
   */
  @TableField("yearMonth")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime yearMonth;

  /**
   * 税号
   */
  @TableField("taxNo")
  private String taxNo;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 未授权货物名称
   */
  @TableField("unauthorizedItemName")
  private String unauthorizedItemName;

  /**
   * 未授权货物代码
   */
  @TableField("unauthorizedItemCode")
  private String unauthorizedItemCode;

  /**
   * 未授权货物及服务名称
   */
  @TableField("unauthorizedCargoName")
  private String unauthorizedCargoName;

  /**
   * 未授权货物及服务代码
   */
  @TableField("unauthorizedCargoCode")
  private String unauthorizedCargoCode;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 税编简称
   */
  @TableField("itemShortName")
  private String itemShortName;

  /**
   * 商品税目
   */
  @TableField("taxItem")
  private String taxItem;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票总量
   */
  @TableField("invoiceQuantity")
  private Long invoiceQuantity;

  /**
   * 发票总额
   */
  @TableField("invoiceAmount")
  private BigDecimal invoiceAmount;

  /**
   * jv Code
   */
  @TableField("jvCode")
  private String jvCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("yearMonth", BocpGenUtils.toTimestamp(yearMonth));
      map.put("taxNo", taxNo);
      map.put("companyName", companyName);
      map.put("unauthorizedItemName", unauthorizedItemName);
      map.put("unauthorizedItemCode", unauthorizedItemCode);
      map.put("unauthorizedCargoName", unauthorizedCargoName);
      map.put("unauthorizedCargoCode", unauthorizedCargoCode);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("itemShortName", itemShortName);
      map.put("taxItem", taxItem);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceQuantity", invoiceQuantity);
      map.put("invoiceAmount", invoiceAmount);
      map.put("jvCode", jvCode);
      return map;
  }

  public static SellerInvoiceCargoDiff fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SellerInvoiceCargoDiff entity = new SellerInvoiceCargoDiff();
    if(map.containsKey("yearMonth")) {
      Object obj = map.get("yearMonth");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setYearMonth(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setYearMonth((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setYearMonth(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setYearMonth(null);
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unauthorizedItemName")) {
      Object obj = map.get("unauthorizedItemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnauthorizedItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unauthorizedItemCode")) {
      Object obj = map.get("unauthorizedItemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnauthorizedItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unauthorizedCargoName")) {
      Object obj = map.get("unauthorizedCargoName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnauthorizedCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unauthorizedCargoCode")) {
      Object obj = map.get("unauthorizedCargoCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnauthorizedCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxItem")) {
      Object obj = map.get("taxItem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceQuantity")) {
      Object obj = map.get("invoiceQuantity");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceQuantity((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceQuantity(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceQuantity(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jvCode")) {
      Object obj = map.get("jvCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
