package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.BlackListConfig;
import com.xforceplus.walmartreport.service.IBlackListConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-18
 */
@RestController
public class BlackListConfigController {

  @Autowired
  private IBlackListConfigService blackListConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param blackListConfig ${table.comment}
   * @return
   */
  @GetMapping("/blacklistconfigs" )
  public XfR getBlackListConfigs(XfPage page, BlackListConfig blackListConfig) {
    return XfR.ok(blackListConfigServiceImpl.page(page, Wrappers.query(blackListConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/blacklistconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(blackListConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param blackListConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/blacklistconfigs")
  public XfR save(@RequestBody BlackListConfig blackListConfig) {
     return XfR.ok(blackListConfigServiceImpl.save(blackListConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param blackListConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/blacklistconfigs/{id}")
  public XfR putUpdate(@RequestBody BlackListConfig blackListConfig,@PathVariable Long id) {
      blackListConfig.setId(id);
      return XfR.ok(blackListConfigServiceImpl.updateById(blackListConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param blackListConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/blacklistconfigs/{id}")
  public XfR patchUpdate(@RequestBody BlackListConfig blackListConfig,@PathVariable Long id) {
      BlackListConfig upblackListConfig = blackListConfigServiceImpl.getById(id);
      if(upblackListConfig != null){
        upblackListConfig = ObjectCopyUtils.copyProperties(blackListConfig,upblackListConfig,true);
      }
      return XfR.ok(blackListConfigServiceImpl.updateById(upblackListConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/blacklistconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(blackListConfigServiceImpl.removeById(id));
  }

  @PostMapping("/blacklistconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "black_list_config");
     params.put("request", condition);

     return XfR.ok(blackListConfigServiceImpl.querys(params));
  }

}
