package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.InvSellerInvoiceItem;
import com.xforceplus.walmartreport.service.IInvSellerInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-18
 */
@RestController
public class InvSellerInvoiceItemController {

  @Autowired
  private IInvSellerInvoiceItemService invSellerInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invSellerInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/invsellerinvoiceitems" )
  public XfR getInvSellerInvoiceItems(XfPage page, InvSellerInvoiceItem invSellerInvoiceItem) {
    return XfR.ok(invSellerInvoiceItemServiceImpl.page(page, Wrappers.query(invSellerInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invsellerinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invSellerInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invSellerInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/invsellerinvoiceitems")
  public XfR save(@RequestBody InvSellerInvoiceItem invSellerInvoiceItem) {
     return XfR.ok(invSellerInvoiceItemServiceImpl.save(invSellerInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invSellerInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/invsellerinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody InvSellerInvoiceItem invSellerInvoiceItem,@PathVariable Long id) {
      invSellerInvoiceItem.setId(id);
      return XfR.ok(invSellerInvoiceItemServiceImpl.updateById(invSellerInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invSellerInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invsellerinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody InvSellerInvoiceItem invSellerInvoiceItem,@PathVariable Long id) {
      InvSellerInvoiceItem upinvSellerInvoiceItem = invSellerInvoiceItemServiceImpl.getById(id);
      if(upinvSellerInvoiceItem != null){
        upinvSellerInvoiceItem = ObjectCopyUtils.copyProperties(invSellerInvoiceItem,upinvSellerInvoiceItem,true);
      }
      return XfR.ok(invSellerInvoiceItemServiceImpl.updateById(upinvSellerInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invsellerinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invSellerInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/invsellerinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_seller_invoice_item");
     params.put("request", condition);

     return XfR.ok(invSellerInvoiceItemServiceImpl.querys(params));
  }

}
