package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.OrgAdmin;
import com.xforceplus.walmartreport.service.IOrgAdminService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-18
 */
@RestController
public class OrgAdminController {

  @Autowired
  private IOrgAdminService orgAdminServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orgAdmin ${table.comment}
   * @return
   */
  @GetMapping("/orgadmins" )
  public XfR getOrgAdmins(XfPage page, OrgAdmin orgAdmin) {
    return XfR.ok(orgAdminServiceImpl.page(page, Wrappers.query(orgAdmin)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orgadmins/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgAdminServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orgAdmin ${table.comment}
   * @return XfR
   */
  @PostMapping("/orgadmins")
  public XfR save(@RequestBody OrgAdmin orgAdmin) {
     return XfR.ok(orgAdminServiceImpl.save(orgAdmin));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orgAdmin ${table.comment}
   * @return XfR
   */
  @PutMapping("/orgadmins/{id}")
  public XfR putUpdate(@RequestBody OrgAdmin orgAdmin,@PathVariable Long id) {
      orgAdmin.setId(id);
      return XfR.ok(orgAdminServiceImpl.updateById(orgAdmin));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orgAdmin ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orgadmins/{id}")
  public XfR patchUpdate(@RequestBody OrgAdmin orgAdmin,@PathVariable Long id) {
      OrgAdmin uporgAdmin = orgAdminServiceImpl.getById(id);
      if(uporgAdmin != null){
        uporgAdmin = ObjectCopyUtils.copyProperties(orgAdmin,uporgAdmin,true);
      }
      return XfR.ok(orgAdminServiceImpl.updateById(uporgAdmin));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orgadmins/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgAdminServiceImpl.removeById(id));
  }

  @PostMapping("/orgadmins/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org_admin");
     params.put("request", condition);

     return XfR.ok(orgAdminServiceImpl.querys(params));
  }

}
