package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.SellerInvoiceCargoDiff;
import com.xforceplus.walmartreport.service.ISellerInvoiceCargoDiffService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22前端控制器
 *
 * @author ultraman
 * @date 2022-08-18
 */
@RestController
public class SellerInvoiceCargoDiffController {

  @Autowired
  private ISellerInvoiceCargoDiffService sellerInvoiceCargoDiffServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceCargoDiff 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @return
   */
  @GetMapping("/sellerinvoicecargodiffs" )
  public XfR getSellerInvoiceCargoDiffs(XfPage page, SellerInvoiceCargoDiff sellerInvoiceCargoDiff) {
    return XfR.ok(sellerInvoiceCargoDiffServiceImpl.page(page, Wrappers.query(sellerInvoiceCargoDiff)));
  }

  /**
   * 通过id查询销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoicecargodiffs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceCargoDiffServiceImpl.getById(id));
  }

  /**
   * 新增销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param sellerInvoiceCargoDiff 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @return XfR
   */
  @PostMapping("/sellerinvoicecargodiffs")
  public XfR save(@RequestBody SellerInvoiceCargoDiff sellerInvoiceCargoDiff) {
     return XfR.ok(sellerInvoiceCargoDiffServiceImpl.save(sellerInvoiceCargoDiff));
  }

  /**
   * 修改-传入修改后的全部数据销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param sellerInvoiceCargoDiff 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @return XfR
   */
  @PutMapping("/sellerinvoicecargodiffs/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceCargoDiff sellerInvoiceCargoDiff,@PathVariable Long id) {
      sellerInvoiceCargoDiff.setId(id);
      return XfR.ok(sellerInvoiceCargoDiffServiceImpl.updateById(sellerInvoiceCargoDiff));
  }

  /**
   * 修改-传入修改的数据销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param sellerInvoiceCargoDiff 销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @return XfR
   */
  @PatchMapping("/sellerinvoicecargodiffs/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceCargoDiff sellerInvoiceCargoDiff,@PathVariable Long id) {
      SellerInvoiceCargoDiff upsellerInvoiceCargoDiff = sellerInvoiceCargoDiffServiceImpl.getById(id);
      if(upsellerInvoiceCargoDiff != null){
        upsellerInvoiceCargoDiff = ObjectCopyUtils.copyProperties(sellerInvoiceCargoDiff,upsellerInvoiceCargoDiff,true);
      }
      return XfR.ok(sellerInvoiceCargoDiffServiceImpl.updateById(upsellerInvoiceCargoDiff));
  }

  /**
   * 通过id删除销项发票进入平台的时候，校验它的明细里面，有没有超出字典的品类，有的话该发票就要体现在“销项开票品类差异”的对象上22
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoicecargodiffs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceCargoDiffServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoicecargodiffs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_cargo_diff");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceCargoDiffServiceImpl.querys(params));
  }

}
