package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.TaxGoodsNo;
import com.xforceplus.walmartreport.service.ITaxGoodsNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-18
 */
@RestController
public class TaxGoodsNoController {

  @Autowired
  private ITaxGoodsNoService taxGoodsNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxGoodsNo ${table.comment}
   * @return
   */
  @GetMapping("/taxgoodsnos" )
  public XfR getTaxGoodsNos(XfPage page, TaxGoodsNo taxGoodsNo) {
    return XfR.ok(taxGoodsNoServiceImpl.page(page, Wrappers.query(taxGoodsNo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxgoodsnos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxGoodsNoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxGoodsNo ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxgoodsnos")
  public XfR save(@RequestBody TaxGoodsNo taxGoodsNo) {
     return XfR.ok(taxGoodsNoServiceImpl.save(taxGoodsNo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxGoodsNo ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxgoodsnos/{id}")
  public XfR putUpdate(@RequestBody TaxGoodsNo taxGoodsNo,@PathVariable Long id) {
      taxGoodsNo.setId(id);
      return XfR.ok(taxGoodsNoServiceImpl.updateById(taxGoodsNo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxGoodsNo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxgoodsnos/{id}")
  public XfR patchUpdate(@RequestBody TaxGoodsNo taxGoodsNo,@PathVariable Long id) {
      TaxGoodsNo uptaxGoodsNo = taxGoodsNoServiceImpl.getById(id);
      if(uptaxGoodsNo != null){
        uptaxGoodsNo = ObjectCopyUtils.copyProperties(taxGoodsNo,uptaxGoodsNo,true);
      }
      return XfR.ok(taxGoodsNoServiceImpl.updateById(uptaxGoodsNo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxgoodsnos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxGoodsNoServiceImpl.removeById(id));
  }

  @PostMapping("/taxgoodsnos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_goods_no");
     params.put("request", condition);

     return XfR.ok(taxGoodsNoServiceImpl.querys(params));
  }

}
