package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.CargoDiffRelated;
import com.xforceplus.walmartreport.service.ICargoDiffRelatedService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 1对1 和 1对1前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class CargoDiffRelatedController {

  @Autowired
  private ICargoDiffRelatedService cargoDiffRelatedServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cargoDiffRelated 1对1 和 1对1
   * @return
   */
  @GetMapping("/cargodiffrelateds" )
  public XfR getCargoDiffRelateds(XfPage page, CargoDiffRelated cargoDiffRelated) {
    return XfR.ok(cargoDiffRelatedServiceImpl.page(page, Wrappers.query(cargoDiffRelated)));
  }

  /**
   * 通过id查询1对1 和 1对1
   * @param  id
   * @return XfR
   */
  @GetMapping("/cargodiffrelateds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cargoDiffRelatedServiceImpl.getById(id));
  }

  /**
   * 新增1对1 和 1对1
   * @param cargoDiffRelated 1对1 和 1对1
   * @return XfR
   */
  @PostMapping("/cargodiffrelateds")
  public XfR save(@RequestBody CargoDiffRelated cargoDiffRelated) {
     return XfR.ok(cargoDiffRelatedServiceImpl.save(cargoDiffRelated));
  }

  /**
   * 修改-传入修改后的全部数据1对1 和 1对1
   * @param cargoDiffRelated 1对1 和 1对1
   * @return XfR
   */
  @PutMapping("/cargodiffrelateds/{id}")
  public XfR putUpdate(@RequestBody CargoDiffRelated cargoDiffRelated,@PathVariable Long id) {
      cargoDiffRelated.setId(id);
      return XfR.ok(cargoDiffRelatedServiceImpl.updateById(cargoDiffRelated));
  }

  /**
   * 修改-传入修改的数据1对1 和 1对1
   * @param cargoDiffRelated 1对1 和 1对1
   * @return XfR
   */
  @PatchMapping("/cargodiffrelateds/{id}")
  public XfR patchUpdate(@RequestBody CargoDiffRelated cargoDiffRelated,@PathVariable Long id) {
      CargoDiffRelated upcargoDiffRelated = cargoDiffRelatedServiceImpl.getById(id);
      if(upcargoDiffRelated != null){
        upcargoDiffRelated = ObjectCopyUtils.copyProperties(cargoDiffRelated,upcargoDiffRelated,true);
      }
      return XfR.ok(cargoDiffRelatedServiceImpl.updateById(upcargoDiffRelated));
  }

  /**
   * 通过id删除1对1 和 1对1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cargodiffrelateds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cargoDiffRelatedServiceImpl.removeById(id));
  }

  @PostMapping("/cargodiffrelateds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cargo_diff_related");
     params.put("request", condition);

     return XfR.ok(cargoDiffRelatedServiceImpl.querys(params));
  }

}
