package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.InvPurchaserInvoiceItem;
import com.xforceplus.walmartreport.service.IInvPurchaserInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class InvPurchaserInvoiceItemController {

  @Autowired
  private IInvPurchaserInvoiceItemService invPurchaserInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invPurchaserInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/invpurchaserinvoiceitems" )
  public XfR getInvPurchaserInvoiceItems(XfPage page, InvPurchaserInvoiceItem invPurchaserInvoiceItem) {
    return XfR.ok(invPurchaserInvoiceItemServiceImpl.page(page, Wrappers.query(invPurchaserInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invpurchaserinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invPurchaserInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invPurchaserInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/invpurchaserinvoiceitems")
  public XfR save(@RequestBody InvPurchaserInvoiceItem invPurchaserInvoiceItem) {
     return XfR.ok(invPurchaserInvoiceItemServiceImpl.save(invPurchaserInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invPurchaserInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/invpurchaserinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody InvPurchaserInvoiceItem invPurchaserInvoiceItem,@PathVariable Long id) {
      invPurchaserInvoiceItem.setId(id);
      return XfR.ok(invPurchaserInvoiceItemServiceImpl.updateById(invPurchaserInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invPurchaserInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invpurchaserinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody InvPurchaserInvoiceItem invPurchaserInvoiceItem,@PathVariable Long id) {
      InvPurchaserInvoiceItem upinvPurchaserInvoiceItem = invPurchaserInvoiceItemServiceImpl.getById(id);
      if(upinvPurchaserInvoiceItem != null){
        upinvPurchaserInvoiceItem = ObjectCopyUtils.copyProperties(invPurchaserInvoiceItem,upinvPurchaserInvoiceItem,true);
      }
      return XfR.ok(invPurchaserInvoiceItemServiceImpl.updateById(upinvPurchaserInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invpurchaserinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invPurchaserInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/invpurchaserinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_purchaser_invoice_item");
     params.put("request", condition);

     return XfR.ok(invPurchaserInvoiceItemServiceImpl.querys(params));
  }

}
