package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.InvPurchaserInvoiceMain;
import com.xforceplus.walmartreport.service.IInvPurchaserInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class InvPurchaserInvoiceMainController {

  @Autowired
  private IInvPurchaserInvoiceMainService invPurchaserInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invPurchaserInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/invpurchaserinvoicemains" )
  public XfR getInvPurchaserInvoiceMains(XfPage page, InvPurchaserInvoiceMain invPurchaserInvoiceMain) {
    return XfR.ok(invPurchaserInvoiceMainServiceImpl.page(page, Wrappers.query(invPurchaserInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invpurchaserinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invPurchaserInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invPurchaserInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/invpurchaserinvoicemains")
  public XfR save(@RequestBody InvPurchaserInvoiceMain invPurchaserInvoiceMain) {
     return XfR.ok(invPurchaserInvoiceMainServiceImpl.save(invPurchaserInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invPurchaserInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/invpurchaserinvoicemains/{id}")
  public XfR putUpdate(@RequestBody InvPurchaserInvoiceMain invPurchaserInvoiceMain,@PathVariable Long id) {
      invPurchaserInvoiceMain.setId(id);
      return XfR.ok(invPurchaserInvoiceMainServiceImpl.updateById(invPurchaserInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invPurchaserInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invpurchaserinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody InvPurchaserInvoiceMain invPurchaserInvoiceMain,@PathVariable Long id) {
      InvPurchaserInvoiceMain upinvPurchaserInvoiceMain = invPurchaserInvoiceMainServiceImpl.getById(id);
      if(upinvPurchaserInvoiceMain != null){
        upinvPurchaserInvoiceMain = ObjectCopyUtils.copyProperties(invPurchaserInvoiceMain,upinvPurchaserInvoiceMain,true);
      }
      return XfR.ok(invPurchaserInvoiceMainServiceImpl.updateById(upinvPurchaserInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invpurchaserinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invPurchaserInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/invpurchaserinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_purchaser_invoice_main");
     params.put("request", condition);

     return XfR.ok(invPurchaserInvoiceMainServiceImpl.querys(params));
  }

}
