package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.InvSellerRedNotification;
import com.xforceplus.walmartreport.service.IInvSellerRedNotificationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class InvSellerRedNotificationController {

  @Autowired
  private IInvSellerRedNotificationService invSellerRedNotificationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invSellerRedNotification ${table.comment}
   * @return
   */
  @GetMapping("/invsellerrednotifications" )
  public XfR getInvSellerRedNotifications(XfPage page, InvSellerRedNotification invSellerRedNotification) {
    return XfR.ok(invSellerRedNotificationServiceImpl.page(page, Wrappers.query(invSellerRedNotification)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invsellerrednotifications/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invSellerRedNotificationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invSellerRedNotification ${table.comment}
   * @return XfR
   */
  @PostMapping("/invsellerrednotifications")
  public XfR save(@RequestBody InvSellerRedNotification invSellerRedNotification) {
     return XfR.ok(invSellerRedNotificationServiceImpl.save(invSellerRedNotification));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invSellerRedNotification ${table.comment}
   * @return XfR
   */
  @PutMapping("/invsellerrednotifications/{id}")
  public XfR putUpdate(@RequestBody InvSellerRedNotification invSellerRedNotification,@PathVariable Long id) {
      invSellerRedNotification.setId(id);
      return XfR.ok(invSellerRedNotificationServiceImpl.updateById(invSellerRedNotification));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invSellerRedNotification ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invsellerrednotifications/{id}")
  public XfR patchUpdate(@RequestBody InvSellerRedNotification invSellerRedNotification,@PathVariable Long id) {
      InvSellerRedNotification upinvSellerRedNotification = invSellerRedNotificationServiceImpl.getById(id);
      if(upinvSellerRedNotification != null){
        upinvSellerRedNotification = ObjectCopyUtils.copyProperties(invSellerRedNotification,upinvSellerRedNotification,true);
      }
      return XfR.ok(invSellerRedNotificationServiceImpl.updateById(upinvSellerRedNotification));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invsellerrednotifications/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invSellerRedNotificationServiceImpl.removeById(id));
  }

  @PostMapping("/invsellerrednotifications/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_seller_red_notification");
     params.put("request", condition);

     return XfR.ok(invSellerRedNotificationServiceImpl.querys(params));
  }

}
