package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.InvSellerRedNotificationDetail;
import com.xforceplus.walmartreport.service.IInvSellerRedNotificationDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class InvSellerRedNotificationDetailController {

  @Autowired
  private IInvSellerRedNotificationDetailService invSellerRedNotificationDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invSellerRedNotificationDetail ${table.comment}
   * @return
   */
  @GetMapping("/invsellerrednotificationdetails" )
  public XfR getInvSellerRedNotificationDetails(XfPage page, InvSellerRedNotificationDetail invSellerRedNotificationDetail) {
    return XfR.ok(invSellerRedNotificationDetailServiceImpl.page(page, Wrappers.query(invSellerRedNotificationDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invsellerrednotificationdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invSellerRedNotificationDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invSellerRedNotificationDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/invsellerrednotificationdetails")
  public XfR save(@RequestBody InvSellerRedNotificationDetail invSellerRedNotificationDetail) {
     return XfR.ok(invSellerRedNotificationDetailServiceImpl.save(invSellerRedNotificationDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invSellerRedNotificationDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/invsellerrednotificationdetails/{id}")
  public XfR putUpdate(@RequestBody InvSellerRedNotificationDetail invSellerRedNotificationDetail,@PathVariable Long id) {
      invSellerRedNotificationDetail.setId(id);
      return XfR.ok(invSellerRedNotificationDetailServiceImpl.updateById(invSellerRedNotificationDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invSellerRedNotificationDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invsellerrednotificationdetails/{id}")
  public XfR patchUpdate(@RequestBody InvSellerRedNotificationDetail invSellerRedNotificationDetail,@PathVariable Long id) {
      InvSellerRedNotificationDetail upinvSellerRedNotificationDetail = invSellerRedNotificationDetailServiceImpl.getById(id);
      if(upinvSellerRedNotificationDetail != null){
        upinvSellerRedNotificationDetail = ObjectCopyUtils.copyProperties(invSellerRedNotificationDetail,upinvSellerRedNotificationDetail,true);
      }
      return XfR.ok(invSellerRedNotificationDetailServiceImpl.updateById(upinvSellerRedNotificationDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invsellerrednotificationdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invSellerRedNotificationDetailServiceImpl.removeById(id));
  }

  @PostMapping("/invsellerrednotificationdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_seller_red_notification_detail");
     params.put("request", condition);

     return XfR.ok(invSellerRedNotificationDetailServiceImpl.querys(params));
  }

}
