package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.InvoiceCargoAdmin;
import com.xforceplus.walmartreport.service.IInvoiceCargoAdminService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class InvoiceCargoAdminController {

  @Autowired
  private IInvoiceCargoAdminService invoiceCargoAdminServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceCargoAdmin ${table.comment}
   * @return
   */
  @GetMapping("/invoicecargoadmins" )
  public XfR getInvoiceCargoAdmins(XfPage page, InvoiceCargoAdmin invoiceCargoAdmin) {
    return XfR.ok(invoiceCargoAdminServiceImpl.page(page, Wrappers.query(invoiceCargoAdmin)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicecargoadmins/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceCargoAdminServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceCargoAdmin ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicecargoadmins")
  public XfR save(@RequestBody InvoiceCargoAdmin invoiceCargoAdmin) {
     return XfR.ok(invoiceCargoAdminServiceImpl.save(invoiceCargoAdmin));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceCargoAdmin ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicecargoadmins/{id}")
  public XfR putUpdate(@RequestBody InvoiceCargoAdmin invoiceCargoAdmin,@PathVariable Long id) {
      invoiceCargoAdmin.setId(id);
      return XfR.ok(invoiceCargoAdminServiceImpl.updateById(invoiceCargoAdmin));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceCargoAdmin ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicecargoadmins/{id}")
  public XfR patchUpdate(@RequestBody InvoiceCargoAdmin invoiceCargoAdmin,@PathVariable Long id) {
      InvoiceCargoAdmin upinvoiceCargoAdmin = invoiceCargoAdminServiceImpl.getById(id);
      if(upinvoiceCargoAdmin != null){
        upinvoiceCargoAdmin = ObjectCopyUtils.copyProperties(invoiceCargoAdmin,upinvoiceCargoAdmin,true);
      }
      return XfR.ok(invoiceCargoAdminServiceImpl.updateById(upinvoiceCargoAdmin));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicecargoadmins/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceCargoAdminServiceImpl.removeById(id));
  }

  @PostMapping("/invoicecargoadmins/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_cargo_admin");
     params.put("request", condition);

     return XfR.ok(invoiceCargoAdminServiceImpl.querys(params));
  }

}
