package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.NoticeAdmin;
import com.xforceplus.walmartreport.service.INoticeAdminService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class NoticeAdminController {

  @Autowired
  private INoticeAdminService noticeAdminServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param noticeAdmin ${table.comment}
   * @return
   */
  @GetMapping("/noticeadmins" )
  public XfR getNoticeAdmins(XfPage page, NoticeAdmin noticeAdmin) {
    return XfR.ok(noticeAdminServiceImpl.page(page, Wrappers.query(noticeAdmin)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/noticeadmins/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(noticeAdminServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param noticeAdmin ${table.comment}
   * @return XfR
   */
  @PostMapping("/noticeadmins")
  public XfR save(@RequestBody NoticeAdmin noticeAdmin) {
     return XfR.ok(noticeAdminServiceImpl.save(noticeAdmin));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param noticeAdmin ${table.comment}
   * @return XfR
   */
  @PutMapping("/noticeadmins/{id}")
  public XfR putUpdate(@RequestBody NoticeAdmin noticeAdmin,@PathVariable Long id) {
      noticeAdmin.setId(id);
      return XfR.ok(noticeAdminServiceImpl.updateById(noticeAdmin));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param noticeAdmin ${table.comment}
   * @return XfR
   */
  @PatchMapping("/noticeadmins/{id}")
  public XfR patchUpdate(@RequestBody NoticeAdmin noticeAdmin,@PathVariable Long id) {
      NoticeAdmin upnoticeAdmin = noticeAdminServiceImpl.getById(id);
      if(upnoticeAdmin != null){
        upnoticeAdmin = ObjectCopyUtils.copyProperties(noticeAdmin,upnoticeAdmin,true);
      }
      return XfR.ok(noticeAdminServiceImpl.updateById(upnoticeAdmin));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/noticeadmins/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(noticeAdminServiceImpl.removeById(id));
  }

  @PostMapping("/noticeadmins/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "notice_admin");
     params.put("request", condition);

     return XfR.ok(noticeAdminServiceImpl.querys(params));
  }

}
