package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.RecordLog;
import com.xforceplus.walmartreport.service.IRecordLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class RecordLogController {

  @Autowired
  private IRecordLogService recordLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param recordLog ${table.comment}
   * @return
   */
  @GetMapping("/recordlogs" )
  public XfR getRecordLogs(XfPage page, RecordLog recordLog) {
    return XfR.ok(recordLogServiceImpl.page(page, Wrappers.query(recordLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/recordlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(recordLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param recordLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/recordlogs")
  public XfR save(@RequestBody RecordLog recordLog) {
     return XfR.ok(recordLogServiceImpl.save(recordLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param recordLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/recordlogs/{id}")
  public XfR putUpdate(@RequestBody RecordLog recordLog,@PathVariable Long id) {
      recordLog.setId(id);
      return XfR.ok(recordLogServiceImpl.updateById(recordLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param recordLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/recordlogs/{id}")
  public XfR patchUpdate(@RequestBody RecordLog recordLog,@PathVariable Long id) {
      RecordLog uprecordLog = recordLogServiceImpl.getById(id);
      if(uprecordLog != null){
        uprecordLog = ObjectCopyUtils.copyProperties(recordLog,uprecordLog,true);
      }
      return XfR.ok(recordLogServiceImpl.updateById(uprecordLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/recordlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(recordLogServiceImpl.removeById(id));
  }

  @PostMapping("/recordlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "record_log");
     params.put("request", condition);

     return XfR.ok(recordLogServiceImpl.querys(params));
  }

}
