package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.TaxCategoryCode;
import com.xforceplus.walmartreport.service.ITaxCategoryCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class TaxCategoryCodeController {

  @Autowired
  private ITaxCategoryCodeService taxCategoryCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxCategoryCode ${table.comment}
   * @return
   */
  @GetMapping("/taxcategorycodes" )
  public XfR getTaxCategoryCodes(XfPage page, TaxCategoryCode taxCategoryCode) {
    return XfR.ok(taxCategoryCodeServiceImpl.page(page, Wrappers.query(taxCategoryCode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxcategorycodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxCategoryCodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxCategoryCode ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxcategorycodes")
  public XfR save(@RequestBody TaxCategoryCode taxCategoryCode) {
     return XfR.ok(taxCategoryCodeServiceImpl.save(taxCategoryCode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxCategoryCode ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxcategorycodes/{id}")
  public XfR putUpdate(@RequestBody TaxCategoryCode taxCategoryCode,@PathVariable Long id) {
      taxCategoryCode.setId(id);
      return XfR.ok(taxCategoryCodeServiceImpl.updateById(taxCategoryCode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxCategoryCode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxcategorycodes/{id}")
  public XfR patchUpdate(@RequestBody TaxCategoryCode taxCategoryCode,@PathVariable Long id) {
      TaxCategoryCode uptaxCategoryCode = taxCategoryCodeServiceImpl.getById(id);
      if(uptaxCategoryCode != null){
        uptaxCategoryCode = ObjectCopyUtils.copyProperties(taxCategoryCode,uptaxCategoryCode,true);
      }
      return XfR.ok(taxCategoryCodeServiceImpl.updateById(uptaxCategoryCode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxcategorycodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxCategoryCodeServiceImpl.removeById(id));
  }

  @PostMapping("/taxcategorycodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_category_code");
     params.put("request", condition);

     return XfR.ok(taxCategoryCodeServiceImpl.querys(params));
  }

}
