package com.xforceplus.walmartreport.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.walmartreport.entity.TaxCategoryIndex;
import com.xforceplus.walmartreport.service.ITaxCategoryIndexService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-05
 */
@RestController
public class TaxCategoryIndexController {

  @Autowired
  private ITaxCategoryIndexService taxCategoryIndexServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxCategoryIndex ${table.comment}
   * @return
   */
  @GetMapping("/taxcategoryindexs" )
  public XfR getTaxCategoryIndexs(XfPage page, TaxCategoryIndex taxCategoryIndex) {
    return XfR.ok(taxCategoryIndexServiceImpl.page(page, Wrappers.query(taxCategoryIndex)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxcategoryindexs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxCategoryIndexServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxCategoryIndex ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxcategoryindexs")
  public XfR save(@RequestBody TaxCategoryIndex taxCategoryIndex) {
     return XfR.ok(taxCategoryIndexServiceImpl.save(taxCategoryIndex));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxCategoryIndex ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxcategoryindexs/{id}")
  public XfR putUpdate(@RequestBody TaxCategoryIndex taxCategoryIndex,@PathVariable Long id) {
      taxCategoryIndex.setId(id);
      return XfR.ok(taxCategoryIndexServiceImpl.updateById(taxCategoryIndex));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxCategoryIndex ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxcategoryindexs/{id}")
  public XfR patchUpdate(@RequestBody TaxCategoryIndex taxCategoryIndex,@PathVariable Long id) {
      TaxCategoryIndex uptaxCategoryIndex = taxCategoryIndexServiceImpl.getById(id);
      if(uptaxCategoryIndex != null){
        uptaxCategoryIndex = ObjectCopyUtils.copyProperties(taxCategoryIndex,uptaxCategoryIndex,true);
      }
      return XfR.ok(taxCategoryIndexServiceImpl.updateById(uptaxCategoryIndex));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxcategoryindexs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxCategoryIndexServiceImpl.removeById(id));
  }

  @PostMapping("/taxcategoryindexs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_category_index");
     params.put("request", condition);

     return XfR.ok(taxCategoryIndexServiceImpl.querys(params));
  }

}
