package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据校验状态
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum BillCheckStatus {

    _0("0", "默认"),
    _1("1", "待提交"),
    _2("2", "暂挂起"),
    _3("3", "已锁定"),
    _4("4", "已退回"),
    _5("5", "已作废"),
    _6("6", "已完成");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
