package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 币种
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum CurrencyType {

    CNY("CNY", "人民币"),
    USD("USD", "美元"),
    EUR("EUR", "欧元"),
    JPY("JPY", "日元"),
    NZD("NZD", "新西兰元"),
    SGD("SGD", "新加坡元"),
    CHF("CHF", "瑞士法郎"),
    AUD("AUD", "澳大利亚元"),
    RUB("RUB", "卢布"),
    HKD("HKD", "港币"),
    GBP("GBP", "英镑");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CurrencyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
