package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据外部状态
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum ExtStatus {

    _0("0", "已提交"),
    _1("1", "驳回"),
    _2("2", "审核完成"),
    _3("3", "已作废"),
    _4("4", "未挂接");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExtStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
