package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像大类别
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum ImageCategory {

    _0("0", "未识别类型"),
    _1("1", "封面（结算单）"),
    _2("2", "大发票（单张）"),
    _3("3", "小发票（多张）"),
    _4("4", "裸扫大发票（单张）"),
    _5("5", "附件");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImageCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
