package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像类型
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum ImageType {

    _1("1", "单据"),
    _2("2", "单证"),
    _3("3", "附件"),
    _99("99", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
