package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 物流状态
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum LogisticsStatus {

    _0("0", "待寄送"),
    _1("1", "寄送中"),
    _2("2", "无需寄送");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LogisticsStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
