package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 特殊发票标记
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum SpecialInvoiceFlag {

    _0("0", "-"),
    _1("1", "通行费"),
    _2("2", "成品油"),
    _3("3", "区块链");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
