package com.xforceplus.wilmarimage.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证类型
 * </p>
 *
 * @author ultraman
 * @since 2021-01-18
 */
public enum TicketType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    SE("se", "增值税专用电子发票"),
    CE("ce", "增值税普通电子发票"),
    X("x", "形式发票"),
    PT("pt", "普通发票"),
    T("t", "火车票"),
    TAXI("taxi", "出租车票"),
    QUOTA("quota", "定额发票"),
    TOLL("toll", "过路费发票"),
    VS("vs", "二手车发票"),
    BUS("bus", "客运票"),
    P("p", "飞机票"),
    FJ("fj", "附件"),
    SL("sl", "销货清单"),
    IM("im", "通用机打发票"),
    J("j", "机动车销售统一发票"),
    CJ("cj", "增值税普通发票（卷票)"),
    CB("cb", "增值税电子普通发票（区块链）"),
    CT("ct", "增值税电子普通发票（通行费)"),
    CD("cd", "浙江通用（电子）发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TicketType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

}
