package com.xforceplus.wilmarimage.metadata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* <p>
    * 
    * </p>
*
* @author ultraman
* @since 2021-01-18
*/

public class EntityMeta {

    public interface Image {
        TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "image_type");
        TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "image_source");
        TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "require_ocr_flag");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
        TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "file_url_handle");
        TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "file_url_origin");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "file_type");
        TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "file_type_handle");
        TypedField<String> FILE_ORDER = new TypedField<>(String.class, "file_order");
        TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "file_level");
        TypedField<String> REC_STATUS = new TypedField<>(String.class, "rec_status");
        TypedField<String> TASK_ID = new TypedField<>(String.class, "task_id");
        TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "copy_count");
        TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "rec_start_time");
        TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "rec_end_time");
        TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "bill_image_id");
        TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "ticket_image_id");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "is_manual_unhook");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "return_status");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "image_category");
        TypedField<String> RETURN_REASON = new TypedField<>(String.class, "return_reason");
        TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "return_remark");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "file_url_local");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> PAGE_CODE = new TypedField<>(String.class, "page_code");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "more_file_url");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> IS_ISSUED = new TypedField<>(String.class, "is_issued");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> REL_EXCEPTION_INFO = new TypedField<>(String.class, "rel_exception_info");
        TypedField<String> REL_WARNING_INFO = new TypedField<>(String.class, "rel_warning_info");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> IS_HANG = new TypedField<>(String.class, "is_hang");
        TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "return_type");
        TypedField<Long> TASK_SIGN = new TypedField<>(Long.class, "task_sign");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
    }

    public interface Ticket {
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> REL_WARNING_INFO = new TypedField<>(String.class, "rel_warning_info");
        TypedField<String> REL_EXCEPTION_INFO = new TypedField<>(String.class, "rel_exception_info");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> INVOICE_CODE0 = new TypedField<>(String.class, "invoice_code0");
        TypedField<String> INVOICE_NO0 = new TypedField<>(String.class, "invoice_no0");
        TypedField<LocalDateTime> INVOICE_DATE0 = new TypedField<>(LocalDateTime.class, "invoice_date0");
        TypedField<String> PURCHASER_NAME0 = new TypedField<>(String.class, "purchaser_name0");
        TypedField<String> PURCHASER_TAX_NO0 = new TypedField<>(String.class, "purchaser_tax_no0");
        TypedField<String> SELLER_NAME0 = new TypedField<>(String.class, "seller_name0");
        TypedField<String> SELLER_TAX_NO0 = new TypedField<>(String.class, "seller_tax_no0");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> RECEIVER_NAME = new TypedField<>(String.class, "receiver_name");
        TypedField<String> RECEIVER_TEL = new TypedField<>(String.class, "receiver_tel");
        TypedField<String> RECEIVER_ADDRESS = new TypedField<>(String.class, "receiver_address");
        TypedField<String> PURCHASER_NO0 = new TypedField<>(String.class, "purchaser_no0");
        TypedField<String> SELLER_NO0 = new TypedField<>(String.class, "seller_no0");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> TICKET_TYPE = new TypedField<>(String.class, "ticket_type");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
    }

    public interface ImageCopy {
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
        TypedField<String> COPY_NAME = new TypedField<>(String.class, "copy_name");
        TypedField<Long> PARENT_IMAGE_ID = new TypedField<>(Long.class, "parent_image_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "file_type");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface Label {
        TypedField<String> LABEL_NAME = new TypedField<>(String.class, "label_name");
        TypedField<String> LABEL_REMARK = new TypedField<>(String.class, "label_remark");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface ConfigDataMapping {
        TypedField<String> CONFIG_DATA_MAPPING_CODE = new TypedField<>(String.class, "config_data_mapping_code");
        TypedField<String> CONFIG_DATA_MAPPING_REMARK = new TypedField<>(String.class, "config_data_mapping_remark");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "is_default");
        TypedField<String> DOCUMENT_TYPE = new TypedField<>(String.class, "document_type");
        TypedField<String> CONFIG_DATA_MAPPING_TYPE = new TypedField<>(String.class, "config_data_mapping_type");
        TypedField<String> ENTITY_CODE = new TypedField<>(String.class, "entity_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface ConfigDataMappingItem {
        TypedField<String> META_FIELD = new TypedField<>(String.class, "meta_field");
        TypedField<String> CONFIG_DATA_MAPPING_ITEM_FIELDS = new TypedField<>(String.class, "config_data_mapping_item_fields");
        TypedField<Long> CONFIG_DATA_MAPPING_ID = new TypedField<>(Long.class, "config_data_mapping_id");
        TypedField<String> DEFAULT_VALUE = new TypedField<>(String.class, "default_value");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> VALUE_EXPRESSION = new TypedField<>(String.class, "value_expression");
    }

    public interface TicketInvoice {
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_SELLER_CODE = new TypedField<>(String.class, "origin_seller_code");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<String> REPLACE_TAX_NO = new TypedField<>(String.class, "replace_tax_no");
        TypedField<String> REPLACE_COMPANY_NAME = new TypedField<>(String.class, "replace_company_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketTrain {
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> TRAINS = new TypedField<>(String.class, "trains");
        TypedField<String> START_STATION = new TypedField<>(String.class, "start_station");
        TypedField<String> END_STATION = new TypedField<>(String.class, "end_station");
        TypedField<String> START_DATE = new TypedField<>(String.class, "start_date");
        TypedField<String> START_TIME = new TypedField<>(String.class, "start_time");
        TypedField<String> SEAT = new TypedField<>(String.class, "seat");
        TypedField<String> SEAT_TYPE = new TypedField<>(String.class, "seat_type");
        TypedField<String> CERTIFICATE_NO = new TypedField<>(String.class, "certificate_no");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface LogisticsPostcode {
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface TicketMany {
        TypedField<Long> IMAGE_NUM = new TypedField<>(Long.class, "image_num");
        TypedField<Long> EXCEPTION_NUM = new TypedField<>(Long.class, "exception_num");
        TypedField<Long> WARNING_NUM = new TypedField<>(Long.class, "warning_num");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketAttachment {
        TypedField<String> ATTACHMENT_NAME = new TypedField<>(String.class, "attachment_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketTaxi {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> START_DATE = new TypedField<>(String.class, "start_date");
        TypedField<String> GET_ON_TIME = new TypedField<>(String.class, "get_on_time");
        TypedField<String> MILEAGE = new TypedField<>(String.class, "mileage");
        TypedField<String> GET_OFF_TIME = new TypedField<>(String.class, "get_off_time");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PLACE = new TypedField<>(String.class, "place");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ConfigBillTicketRel {
        TypedField<Long> CONFIG_BILL_TYPE_ID = new TypedField<>(Long.class, "config_bill_type_id");
        TypedField<Long> CONFIG_TICKET_TYPE_ID = new TypedField<>(Long.class, "config_ticket_type_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface BaseBill {
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> REL_WARNING_INFO = new TypedField<>(String.class, "rel_warning_info");
        TypedField<String> REL_EXCEPTION_INFO = new TypedField<>(String.class, "rel_exception_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> TEST_DE = new TypedField<>(String.class, "test_de");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> BUSINESS_STATUS = new TypedField<>(String.class, "business_status");
    }

    public interface SalesBill {
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketForm {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customer_no");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_SELLER_NO = new TypedField<>(String.class, "origin_seller_no");
        TypedField<String> ADDRESS = new TypedField<>(String.class, "address");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractno");
        TypedField<String> FORMNO = new TypedField<>(String.class, "formno");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ConfigSettings {
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "is_default");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<Long> IMAGE_TO_ANNEX_SECONDS = new TypedField<>(Long.class, "image_to_annex_seconds");
        TypedField<String> SCAN_IS_SUPPORT_ALL_TENANT = new TypedField<>(String.class, "scan_is_support_all_tenant");
        TypedField<Long> SEARCH_NO_REAL_DAY = new TypedField<>(Long.class, "search_no_real_day");
        TypedField<String> TICKET_AUTO_SEND_VERIFY = new TypedField<>(String.class, "ticket_auto_send_verify");
        TypedField<String> IS_ALL_PUSH_DATA = new TypedField<>(String.class, "is_all_push_data");
        TypedField<String> TICKET_IS_SUPPORT_REUSE = new TypedField<>(String.class, "ticket_is_support_reuse");
        TypedField<String> TICKET_IS_CHECK_BLACK = new TypedField<>(String.class, "ticket_is_check_black");
        TypedField<String> TICKET_IS_CHECK_SENSITIVE = new TypedField<>(String.class, "ticket_is_check_sensitive");
        TypedField<String> TICKET_IS_CHECK_LEGALPERSON = new TypedField<>(String.class, "ticket_is_check_legalperson");
        TypedField<String> BILL_CODE_IS_NEED_TRANS = new TypedField<>(String.class, "bill_code_is_need_trans");
        TypedField<String> EMPTY_URL = new TypedField<>(String.class, "empty_url");
        TypedField<String> IS_SUPPORT_PSZS = new TypedField<>(String.class, "is_support_pszs");
        TypedField<String> DEBUG_MODEL = new TypedField<>(String.class, "debug_model");
        TypedField<String> SPLIT_MORE_IMAGE = new TypedField<>(String.class, "split_more_image");
        TypedField<String> BILL_TYPE_CODE_NEED_LIST = new TypedField<>(String.class, "bill_type_code_need_list");
        TypedField<String> BILL_CODE_REGEX_SPLIT = new TypedField<>(String.class, "bill_code_regex_split");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> EXTENSION1 = new TypedField<>(String.class, "extension1");
        TypedField<String> EXTENSION2 = new TypedField<>(String.class, "extension2");
        TypedField<String> EXTENSION3 = new TypedField<>(String.class, "extension3");
        TypedField<String> SALES_LIST_CONFIG = new TypedField<>(String.class, "sales_list_config");
        TypedField<String> SCAN_CLIENT_SCAN_MODEL = new TypedField<>(String.class, "scan_client_scan_model");
        TypedField<Long> SHAREPOINT_SEND_IMAGE_NUM = new TypedField<>(Long.class, "sharepoint_send_image_num");
        TypedField<Long> IMAGE_TASK_SERVICE_COUNT = new TypedField<>(Long.class, "image_task_service_count");
    }

    public interface TravelExpenseBill {
        TypedField<String> BUSINESS_USER = new TypedField<>(String.class, "business_user");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketInvoiceDetail {
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> CURRENT_DATE_START = new TypedField<>(String.class, "current_date_start");
        TypedField<String> CURRENT_DATE_END = new TypedField<>(String.class, "current_date_end");
        TypedField<String> LICENSE_PLATE_NUM = new TypedField<>(String.class, "license_plate_num");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface ConfigDictionary {
        TypedField<String> DICT_CODE = new TypedField<>(String.class, "dict_code");
        TypedField<String> DICT_DESC = new TypedField<>(String.class, "dict_desc");
        TypedField<String> DICT_VALUE = new TypedField<>(String.class, "dict_value");
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "is_default");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface TicketQuota {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketPlane {
        TypedField<String> NAME_OF_PASSENGER = new TypedField<>(String.class, "name_of_passenger");
        TypedField<String> ID_NO = new TypedField<>(String.class, "id_no");
        TypedField<String> E_TICKET_NO = new TypedField<>(String.class, "e_ticket_no");
        TypedField<String> ENDORSEMENTS = new TypedField<>(String.class, "endorsements");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serial_no");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INFORMATION = new TypedField<>(String.class, "information");
        TypedField<String> AGENT_CODE = new TypedField<>(String.class, "agent_code");
        TypedField<String> ISSUED_BY = new TypedField<>(String.class, "issued_by");
        TypedField<String> DATE_OF_ISSUE = new TypedField<>(String.class, "date_of_issue");
        TypedField<String> INSURANCE = new TypedField<>(String.class, "insurance");
        TypedField<BigDecimal> FARE = new TypedField<>(BigDecimal.class, "fare");
        TypedField<BigDecimal> CAAC_DEVELOPMENT_FUND = new TypedField<>(BigDecimal.class, "caac_development_fund");
        TypedField<BigDecimal> FUEL_SURCHARGE = new TypedField<>(BigDecimal.class, "fuel_surcharge");
        TypedField<BigDecimal> TOTAL = new TypedField<>(BigDecimal.class, "total");
        TypedField<BigDecimal> TAX = new TypedField<>(BigDecimal.class, "tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketBus {
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "company_name");
        TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "company_tax_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> TRAINS = new TypedField<>(String.class, "trains");
        TypedField<String> START_STATION = new TypedField<>(String.class, "start_station");
        TypedField<String> END_STATION = new TypedField<>(String.class, "end_station");
        TypedField<String> START_DATE = new TypedField<>(String.class, "start_date");
        TypedField<String> START_TIME = new TypedField<>(String.class, "start_time");
        TypedField<String> SEAT = new TypedField<>(String.class, "seat");
        TypedField<String> CARRIER = new TypedField<>(String.class, "carrier");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketToll {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> EXIT_PLACE = new TypedField<>(String.class, "exit_place");
        TypedField<String> ENTRANCE_PLACE = new TypedField<>(String.class, "entrance_place");
        TypedField<String> START_DATE = new TypedField<>(String.class, "start_date");
        TypedField<String> PAYMENT = new TypedField<>(String.class, "payment");
        TypedField<String> VEHICLES_TYPE = new TypedField<>(String.class, "vehicles_type");
        TypedField<String> VEHICLES_WEIGHT = new TypedField<>(String.class, "vehicles_weight");
        TypedField<String> TOLL_LIMIT = new TypedField<>(String.class, "toll_limit");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ReceiveFiles {
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> VOUCHER_CODE = new TypedField<>(String.class, "voucher_code");
        TypedField<String> IMAGE_FILE_URL = new TypedField<>(String.class, "image_file_url");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IMAGE_FILE_TYPE = new TypedField<>(String.class, "image_file_type");
        TypedField<String> BILL_CODE_TYPE = new TypedField<>(String.class, "bill_code_type");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "company_id");
        TypedField<String> FILE_SUFFIX = new TypedField<>(String.class, "file_suffix");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface TicketPlaneDetail {
        TypedField<String> CARRIER = new TypedField<>(String.class, "carrier");
        TypedField<String> PLANE_FROM = new TypedField<>(String.class, "plane_from");
        TypedField<String> PLANE_TO = new TypedField<>(String.class, "plane_to");
        TypedField<String> FLIGHT = new TypedField<>(String.class, "flight");
        TypedField<String> PLANE_DATE = new TypedField<>(String.class, "plane_date");
        TypedField<String> PLANE_TIME = new TypedField<>(String.class, "plane_time");
        TypedField<String> SEAT_CLASS = new TypedField<>(String.class, "seat_class");
        TypedField<String> FARE_BASIS = new TypedField<>(String.class, "fare_basis");
        TypedField<String> NOT_VALID_BEFORE = new TypedField<>(String.class, "not_valid_before");
        TypedField<String> NOT_VALID_AFTER = new TypedField<>(String.class, "not_valid_after");
        TypedField<String> ALLOW = new TypedField<>(String.class, "allow");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface BillTicketRelation {
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> REPEAT_USER_NAME = new TypedField<>(String.class, "repeat_user_name");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
    }

    public interface PublicBill {
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface PrivateBill {
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface PurchaseBill {
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<String> CONTACT_TEL = new TypedField<>(String.class, "contact_tel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface BankBill {
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<String> CONTACT_TEL = new TypedField<>(String.class, "contact_tel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface OtherBill {
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MONTH = new TypedField<>(String.class, "month");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contract_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface ExpensesBill {
        TypedField<String> PETITIONER = new TypedField<>(String.class, "petitioner");
        TypedField<String> CONTACT_TEL = new TypedField<>(String.class, "contact_tel");
        TypedField<Long> REAL_PAGE = new TypedField<>(Long.class, "real_page");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketOther {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customer_no");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_SELLER_NO = new TypedField<>(String.class, "origin_seller_no");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PLACE = new TypedField<>(String.class, "place");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketUsedCar {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> REGISTRATION_NO = new TypedField<>(String.class, "registration_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> VEHICLE_PLACE_NAME = new TypedField<>(String.class, "vehicle_place_name");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> AUCTIONEERS_NAME = new TypedField<>(String.class, "auctioneers_name");
        TypedField<String> AUCTIONEERS_ADDRESS = new TypedField<>(String.class, "auctioneers_address");
        TypedField<String> AUCTIONEERS_TAX_NO = new TypedField<>(String.class, "auctioneers_tax_no");
        TypedField<String> AUCTIONEERS_BANK_INFO = new TypedField<>(String.class, "auctioneers_bank_info");
        TypedField<String> AUCTIONEERS_TEL = new TypedField<>(String.class, "auctioneers_tel");
        TypedField<String> USED_CAR_MARKET_NAME = new TypedField<>(String.class, "used_car_market_name");
        TypedField<String> USED_CAR_MARKET_ADDRESS = new TypedField<>(String.class, "used_car_market_address");
        TypedField<String> USED_CAR_MARKET_TAX_NO = new TypedField<>(String.class, "used_car_market_tax_no");
        TypedField<String> USED_CAR_MARKET_BANK_INFO = new TypedField<>(String.class, "used_car_market_bank_info");
        TypedField<String> USED_CAR_MARKET_TEL = new TypedField<>(String.class, "used_car_market_tel");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> CAR_NUMBER = new TypedField<>(String.class, "car_number");
        TypedField<String> DP_NAME = new TypedField<>(String.class, "dp_name");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface BillTicketReuse {
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> REUSE_USER_NAME = new TypedField<>(String.class, "reuse_user_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }

    public interface TicketSalesList {
        TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "ticket_image_id");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> PURCAHSER_NAME = new TypedField<>(String.class, "purcahser_name");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<BigDecimal> SUB_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "sub_amount_without_tax");
        TypedField<BigDecimal> SUB_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "sub_tax_amount");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketMachine {
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CATEGORY = new TypedField<>(String.class, "category");
        TypedField<String> NETWORK_NO = new TypedField<>(String.class, "network_no");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketMachineDetail {
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface TicketSourceFile {
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "file_name");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "file_type");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> IS_MATCH_INVOICE = new TypedField<>(String.class, "is_match_invoice");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
    }

    public interface Testdeploy {
        TypedField<String> TEST = new TypedField<>(String.class, "TEST");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }

    public interface BackLog {
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "return_type");
        TypedField<String> RETURN_REASON = new TypedField<>(String.class, "return_reason");
        TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "return_remark");
        TypedField<String> RETURN_USER_NAME = new TypedField<>(String.class, "return_user_name");
        TypedField<String> RETURN_USER_ID = new TypedField<>(String.class, "return_user_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<LocalDateTime> RETURN_TIME = new TypedField<>(LocalDateTime.class, "return_time");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> TICKET_TYPE = new TypedField<>(String.class, "ticket_type");
    }

    public interface BillOperationLog {
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> OPERATION_USER_ID = new TypedField<>(String.class, "operation_user_id");
        TypedField<String> OPERATION_USER_NAME = new TypedField<>(String.class, "operation_user_name");
        TypedField<LocalDateTime> OPERATION_TIME = new TypedField<>(LocalDateTime.class, "operation_time");
        TypedField<String> OPERATION_TYPE = new TypedField<>(String.class, "operation_type");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PUSH_SYSTEM = new TypedField<>(String.class, "push_system");
    }

    public interface EpmTicketRecord {
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<String> PARAMS = new TypedField<>(String.class, "params");
        TypedField<LocalDateTime> PUSH_TIME = new TypedField<>(LocalDateTime.class, "push_time");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retry_count");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
    }

    public interface ExceptionMonitor {
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<LocalDateTime> EXCEPTION_TIME = new TypedField<>(LocalDateTime.class, "exception_time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> LOG_ID = new TypedField<>(Long.class, "log_id");
        TypedField<String> NUMBER = new TypedField<>(String.class, "number");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> METHOD_CODE = new TypedField<>(String.class, "method_code");
        TypedField<Long> SYSTEM_TYPE = new TypedField<>(Long.class, "system_type");
        TypedField<String> SENDER = new TypedField<>(String.class, "sender");
        TypedField<String> RECEIVER = new TypedField<>(String.class, "receiver");
        TypedField<String> METHOD_URL = new TypedField<>(String.class, "method_url");
        TypedField<String> METHOD_NAME = new TypedField<>(String.class, "method_name");
        TypedField<String> METHOD_DESCRIPTION = new TypedField<>(String.class, "method_description");
        TypedField<String> PARAMS = new TypedField<>(String.class, "params");
        TypedField<String> RESULT = new TypedField<>(String.class, "result");
        TypedField<String> IS_SUCCESS = new TypedField<>(String.class, "is_success");
        TypedField<String> IS_RETRY = new TypedField<>(String.class, "is_retry");
        TypedField<String> METHOD_TYPE = new TypedField<>(String.class, "method_type");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retry_count");
    }

}
