package com.xforceplus.wilmar.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-07-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.Salesbill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "wilmar-in")
public interface SalesbillFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/salesbill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param salesbill ${table.comment}
   * @return R
   */
  @PostMapping("/salesbill/add")
  public R save(@RequestBody Salesbill salesbill);

  /**
   * 修改${table.comment}
   * @param salesbill ${table.comment}
   * @return R
   */
  @PostMapping("/salesbill/update")
  public R updateById(@RequestBody Salesbill salesbill);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesbill/del/{id}" )
  public R removeById(@PathVariable Long id);

}