package com.xforceplus.wilmar.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-08-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.GoodsReceive;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "wilmar-in")
public interface GoodsReceiveFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/goodsReceive/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param goodsReceive ${table.comment}
   * @return R
   */
  @PostMapping("/goodsReceive/add")
  public R save(@RequestBody GoodsReceive goodsReceive);

  /**
   * 修改${table.comment}
   * @param goodsReceive ${table.comment}
   * @return R
   */
  @PostMapping("/goodsReceive/update")
  public R updateById(@RequestBody GoodsReceive goodsReceive);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsReceive/del/{id}" )
  public R removeById(@PathVariable Long id);

}