package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.AdjustmentAmount;
import com.xforceplus.wilmar.service.IAdjustmentAmountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-02
 */
@RestController
public class AdjustmentAmountController {

  @Autowired
  private IAdjustmentAmountService adjustmentAmountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param adjustmentAmount ${table.comment}
   * @return
   */
  @GetMapping("/adjustmentamounts" )
  public XfR getAdjustmentAmounts(XfPage page, AdjustmentAmount adjustmentAmount) {
    return XfR.ok(adjustmentAmountServiceImpl.page(page, Wrappers.query(adjustmentAmount)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/adjustmentamounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(adjustmentAmountServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param adjustmentAmount ${table.comment}
   * @return XfR
   */
  @PostMapping("/adjustmentamounts")
  public XfR save(@RequestBody AdjustmentAmount adjustmentAmount) {
     return XfR.ok(adjustmentAmountServiceImpl.save(adjustmentAmount));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param adjustmentAmount ${table.comment}
   * @return XfR
   */
  @PutMapping("/adjustmentamounts/{id}")
  public XfR putUpdate(@RequestBody AdjustmentAmount adjustmentAmount,@PathVariable Long id) {
      adjustmentAmount.setId(id);
      return XfR.ok(adjustmentAmountServiceImpl.updateById(adjustmentAmount));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param adjustmentAmount ${table.comment}
   * @return XfR
   */
  @PatchMapping("/adjustmentamounts/{id}")
  public XfR patchUpdate(@RequestBody AdjustmentAmount adjustmentAmount,@PathVariable Long id) {
      AdjustmentAmount upadjustmentAmount = adjustmentAmountServiceImpl.getById(id);
      if(upadjustmentAmount != null){
        upadjustmentAmount = ObjectCopyUtils.copyProperties(adjustmentAmount,upadjustmentAmount,true);
      }
      return XfR.ok(adjustmentAmountServiceImpl.updateById(upadjustmentAmount));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/adjustmentamounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(adjustmentAmountServiceImpl.removeById(id));
  }

  @PostMapping("/adjustmentamounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "adjustmentamount");
      params.put("request", condition);

     return XfR.ok(adjustmentAmountServiceImpl.querys(params));
  }

}
